// watertest4.vsh

uniform mat4 vc0;	// WorldView matrix
uniform mat4 vc4;	// Camera-space matrix
uniform vec3 vc8;
uniform vec3 vc9;
uniform vec3 vc10;
uniform vec3 vc20;
#ifndef NOCOLOR
uniform vec4 vc35;
#endif

varying vec3 EyeVector;
varying float Fresnel;

void main()
{
	// Transform position
	gl_Position = gl_Vertex * vc0;

#ifndef NOCOLOR
	gl_FrontColor = gl_Color;
#endif

	// Calculate texture coords for bump
#ifndef NOCOLOR
	vec2 temp = gl_MultiTexCoord0.st * vc35.x;
	vec2 bumpCoords;
	bumpCoords.x = temp.x * vc35.w + temp.y * -vc35.z;
	bumpCoords.y = temp.x * vc35.z + temp.y * vc35.w + vc35.y;
    gl_TexCoord[0].st = bumpCoords;
#else
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
#endif
	
	// Transform eye vector (from 0 to cam-space vertex) to world space
	// and save world space eye-to-vert vector.

	vec3 r1 = (gl_Vertex * vc4).xyz;
	r1 = -r1;
	
	EyeVector.x = dot(r1, vc8);
	EyeVector.y = dot(r1, vc9);
	EyeVector.z = dot(r1, vc10);
	EyeVector = normalize(EyeVector);

	// Calculate per-vertex Fresnel term
	float eyedot = 1.0 - dot(EyeVector, vec3(0.0,1.0,0.0));	// 1 - Eye dot N
	eyedot *= eyedot;										// ^2

	float bias = vc20.y;
	float scale = vc20.x;
	
	Fresnel = bias + (scale * eyedot);
} 
